# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Early Rounds (1-3)
    if current_round == 1:
        return "D"
    elif current_round <= 3:
        return "C"
    
    # Mid Rounds (4-7)
    elif current_round <= 7:
        if current_round <= 5:
            return "C"
        else:
            return "D" if current_round % 2 == 0 else "C"
    
    # Late Rounds (8-10)
    else:
        if current_round == 9:
            return "C"
        else:
            return "D"